/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWRoster;
import filenet.vw.api.VWRosterQuery;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminCommon;
import filenet.vw.toolkit.admin.result.VWAdminConfirmDialog;
import filenet.vw.toolkit.admin.result.VWAdminConfirmWithCheckBoxDialog;
import filenet.vw.toolkit.admin.result.VWAdminErrorDataObj;
import filenet.vw.toolkit.admin.result.VWAdminErrorsDialog;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.VWAdminResultTableModelBase;
import filenet.vw.toolkit.admin.result.VWAdminWFByWOInRosterTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWOInRosterTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWorkObjectTableData;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.Container;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;

public class VWAdminDeleteWork {
    private boolean m_bSave = false;
    private Vector m_vErrors = new Vector();
    private boolean m_bOverride = false;
    protected VWAdminResultPane m_resultsPane;
    protected VWTable m_resultsTable;
    protected int[] m_selectedRows;
    protected VWAdminResultTableModelBase m_tableModel;
    protected Vector m_wobsList = new Vector();
    protected VWParticipant m_logonUser = null;
    protected Frame m_parentFrame = null;
    protected Container m_mainContainer = null;
    protected ListSelectionModel m_listSelectionModel = null;

    public VWAdminDeleteWork(VWAdminResultPane resultsPane) {
        VWAdminErrorsDialog dlg;
        VWModalDialog confirmDlg;
        this.m_resultsPane = resultsPane;
        this.m_selectedRows = this.m_resultsPane.getSelectedRows();
        this.m_tableModel = this.m_resultsPane.getTableModel();
        this.m_resultsTable = this.m_resultsPane.getResultsTable();
        this.m_listSelectionModel = this.m_resultsTable.getSelectionModel();
        this.m_logonUser = this.m_resultsPane.getLogonUser();
        this.m_mainContainer = this.m_resultsPane.getMainContainer();
        this.m_parentFrame = this.m_resultsPane.getParentFrame();
        if (this.m_logonUser == null) {
            JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_undeterminedLogonUser, VWResource.s_deleteTitle, 1, null);
            return;
        }
        if (this.m_resultsTable.getSelectedRows().length == 0) {
            JOptionPane.showMessageDialog(resultsPane.getParentFrame(), VWResource.s_noRowSelected, VWResource.s_deleteTitle, 1, null);
            return;
        }
        this.buildWobsList(this.m_selectedRows);
        if (VWAdminCommon.isAnyLockedByOthers(this.m_wobsList)) {
            confirmDlg = new VWAdminConfirmWithCheckBoxDialog(this.m_parentFrame, VWResource.s_deleteTitle, VWResource.s_deleteWarning, VWResource.s_override, 2);
            confirmDlg.setVisible(true);
            if (((VWAdminConfirmWithCheckBoxDialog)confirmDlg).isCanceled()) {
                this.removeReferences();
                return;
            }
            this.m_bOverride = ((VWAdminConfirmWithCheckBoxDialog)confirmDlg).isChecked();
        } else {
            confirmDlg = new VWAdminConfirmDialog(this.m_parentFrame, VWResource.s_deleteTitle, VWResource.s_deleteWarning, 2);
            confirmDlg.setVisible(true);
            if (((VWAdminConfirmDialog)confirmDlg).isCanceled()) {
                this.removeReferences();
                return;
            }
            this.m_bOverride = true;
        }
        this.doLock();
        if (this.m_tableModel instanceof VWAdminWFByWOInRosterTableModel && this.m_vErrors.size() != 0) {
            this.m_tableModel.refreshSelectedRows(this.m_selectedRows);
            dlg = new VWAdminErrorsDialog(this.m_parentFrame, VWResource.s_deleteTitle, VWResource.s_cannotLockAllBeforeDelete, this.m_vErrors);
            dlg.setVisible(true);
            this.removeReferences();
            return;
        }
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
        this.doDelete(true);
        this.doDelete(false);
        this.m_listSelectionModel.clearSelection();
        this.m_tableModel.removeWorkObjectsOutOfTable();
        this.m_tableModel.refreshAllRows();
        if (this.m_vErrors.size() != 0) {
            dlg = new VWAdminErrorsDialog(this.m_parentFrame, VWResource.s_deleteTitle, VWResource.s_deleteErr, this.m_vErrors);
            dlg.setVisible(true);
        }
        this.removeReferences();
    }

    private void buildWobsList(int[] rows) {
        try {
            for (int i = 0; i < rows.length; ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_tableModel.getObjectAt(rows[i]);
                this.m_wobsList.addElement(woData);
                VWAdminCommon.addChildrenToWobsList(woData.getChildren(), false, this.m_wobsList);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void doLock() {
        VWWorkObject[] woArray = null;
        Vector<VWWorkObject> woVector = new Vector<VWWorkObject>();
        VWException[] arrayExceptions = null;
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
        if (this.m_tableModel instanceof VWAdminWOInRosterTableModel) {
            for (int i = 0; i < this.m_wobsList.size(); ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_wobsList.elementAt(i);
                if (woData.getLockedStatus() == 1) continue;
                VWWorkObject wob = woData.getWob();
                try {
                    wob.doLock(this.m_bOverride);
                    wob.doRefresh(true, true);
                    woData.updateLockedInfo();
                    continue;
                }
                catch (Exception ex) {
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, ex);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(ex);
                }
            }
        } else {
            int i;
            int i2;
            for (i2 = 0; i2 < this.m_wobsList.size(); ++i2) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_wobsList.elementAt(i2);
                int lockedStatus = woData.getLockedStatus();
                if (woData.getLockedStatus() == 1) continue;
                woVector.addElement(woData.getWob());
            }
            if (woVector.size() != 0) {
                woArray = new VWWorkObject[woVector.size()];
                for (i2 = 0; i2 < woVector.size(); ++i2) {
                    woArray[i2] = (VWWorkObject)woVector.elementAt(i2);
                }
                try {
                    VWWorkObject curWorkObject = woArray[0];
                    arrayExceptions = VWWorkObject.doLockMany(woArray, this.m_bOverride);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            } else {
                return;
            }
            for (i = 0; i < woArray.length; ++i) {
                VWWorkObject wob = woArray[i];
                try {
                    if (arrayExceptions[i] == null) {
                        wob.doRefresh(true, true);
                        VWAdminWorkObjectTableData woData = VWAdminCommon.findWoData(wob, this.m_wobsList);
                        if (woData == null) continue;
                        woData.updateLockedInfo();
                        continue;
                    }
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, arrayExceptions[i]);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(arrayExceptions[i]);
                    continue;
                }
                catch (Exception ex) {
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, arrayExceptions[i]);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(ex);
                }
            }
            if (arrayExceptions != null) {
                for (i = 0; i < arrayExceptions.length; ++i) {
                    arrayExceptions[i] = null;
                }
            }
            if (woArray != null) {
                for (i = 0; i < woArray.length; ++i) {
                    woArray[i] = null;
                }
            }
            if (woVector != null) {
                woVector.removeAllElements();
            }
        }
    }

    private void doDelete(boolean bProcessSystemQueue) {
        for (int i = 0; i < this.m_wobsList.size(); ++i) {
            VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_wobsList.elementAt(i);
            if (woData.isToBeRemoved()) continue;
            VWWorkObject wob = woData.getWob();
            try {
                String queueName = wob.getCurrentQueueName();
                String rosterName = wob.getRosterName();
                VWQueue queue = this.m_resultsPane.getSession().getQueue(queueName);
                int queueType = queue.getQueueType();
                if (bProcessSystemQueue ? queueType != 3 : queue.getQueueType() == 3) continue;
                wob.doTerminate();
                VWWorkObject vwWorkObject = null;
                vwWorkObject = this.fetchSpecificWorkObject(this.m_resultsPane.getSession(), rosterName, wob.getWorkObjectNumber());
                if (vwWorkObject != null) {
                    vwWorkObject.doRefresh(false, false);
                    woData.updateLockedInfo();
                    if (this.doLockSpecificWorkObject(vwWorkObject)) {
                        vwWorkObject.doTerminate();
                    }
                }
                if (woData.getRowIndex() < 0) continue;
                woData.setToBeRemoved(true);
                continue;
            }
            catch (Exception ex) {
                VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, ex);
                this.m_vErrors.addElement(errObj);
                VWDebug.logException(ex);
            }
        }
    }

    private VWWorkObject fetchSpecificWorkObject(VWSession session, String rosterName, String wobNumber) throws Exception {
        VWWorkObject vwWorkObject = null;
        VWRoster vwRoster = null;
        VWRosterQuery vwRosterQuery = null;
        Object[] values = new Object[]{wobNumber};
        int queryFlags = 96;
        try {
            vwRoster = session.getRoster(rosterName);
        }
        catch (VWException e) {
            VWDebug.logException(e);
            throw new Exception(VWResource.s_failedToAccessRoster.toString(rosterName, e.getLocalizedMessage()));
        }
        try {
            vwRosterQuery = vwRoster.createQuery("F_WobNum", values, values, queryFlags, null, null, 1);
            vwWorkObject = (VWWorkObject)vwRosterQuery.next();
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            String s = ex.getLocalizedMessage();
            if (s == null) {
                s = "";
            }
            throw new Exception(VWResource.s_failedToRetrieveWorkInRoster.toString(wobNumber, rosterName, s));
        }
        return vwWorkObject;
    }

    private boolean doLockSpecificWorkObject(VWWorkObject wob) throws Exception {
        boolean bOK = true;
        VWAdminWorkObjectTableData woData = VWAdminCommon.findWoData(wob, this.m_wobsList);
        if (woData != null) {
            if (woData.getLockedStatus() != 1) {
                try {
                    wob.doLock(this.m_bOverride);
                    wob.doRefresh(true, true);
                    woData.updateLockedInfo();
                    return bOK;
                }
                catch (Exception ex) {
                    bOK = false;
                    VWDebug.logException(ex);
                    throw ex;
                }
            }
        } else {
            return false;
        }
        return bOK;
    }

    private void removeReferences() {
        if (this.m_wobsList != null) {
            this.m_wobsList.removeAllElements();
        }
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
    }
}

